//===============================================================================================
// Utility function for gathering the product key and unlock code
//
// Copyright <c> 2003 Intuit, Inc.  All rights reserved
//===============================================================================================

gProdKeyPrefix = "prodKey";
gProdKeyFieldCnt = 4;

gUnlockCodePrefix = "unlockCode";
gUnlockCodeFieldCnt = 5;
gUnlockCodeFieldLen = 4;

//---------------------------------------------------------------------------------------------
function renderEditProductKey()
	// Appends the HTML elements needed to gather the product key from the user
{
	var s="";
	var sz, max;
		
	for( var i=1; i<=gProdKeyFieldCnt; ++i )
	{
		if( i>1 ) s+='<span style="vertical-align:super;font:bold 13px Arial"> - </span>';
		max = ( i%2 == 0 ) ? 4 : 5;
		sz = max-1;
		
		s += '<input size="' + sz + '" maxlength="' + max + '" id="'+ gProdKeyPrefix+i + '"';
		if( i<gProdKeyFieldCnt ) s += ' onkeypress="_onTabProdKey('+i+')"';
		s += '>'
	}

	document.writeln( s );
}

function _onTabProdKey(i)
{
	var e = document.getElementById( gProdKeyPrefix+i );
	if( e && e.value.length==e.maxLength )
	{
		i++;
		setFocus(gProdKeyPrefix+i)
	}
}

//---------------------------------------------------------------------------------------------
function getProductKey()
	// Gather the user entered product key
{
	var e, key = "";
	
	for( var i=1; i<=gProdKeyFieldCnt; ++i)
	{
		e = document.getElementById( gProdKeyPrefix+i );
		if(e) key += e.value;
	}
	
	return key;
}

//---------------------------------------------------------------------------------------------
function initProductKey()
	// Initialize the product key fields if a product key value is present
{
	var key = parent.dataSrcItem("prodKey");
	if( key.length>0 )
	{
		var len = 0, pos=0;
		for( var i=1; i<=gProdKeyFieldCnt; ++i)
		{
			e = document.getElementById( gProdKeyPrefix+i );
			if(e)
			{
				len = e.maxLength;
				e.value = key.substr( pos, len );
				pos += len;
			}	
		}
	}	
}

//---------------------------------------------------------------------------------------------
function validateProdKey()
{
	var len;
	var bValid = true;
	
	for( var i=1; i<=gProdKeyFieldCnt; ++i)
	{
		len = ( i%2==0 ) ? 4 : 5;

		if( !isInputPopulated( gProdKeyPrefix+i, len, len ) )
		{
			bValid = false;
			break;
		}
	}
	
	if( bValid )
	{
		parent.setDataSrcItem( "prodKey", getProductKey() );
		parent.onCmd("isValidProductKey");
		bValid = ("ok"==getLastCmdResult());
	}
	
	return bValid;
}

//---------------------------------------------------------------------------------------------
function toNiceProdKey( prodKey )
{
	// Product key available, show on page
	var niceKey = prodKey.substr( 0, 5 );
	niceKey += '-';
	niceKey += prodKey.substr( 5, 4 );
	niceKey += '-';
	niceKey += prodKey.substr( 9, 5 );
	niceKey += '-';
	niceKey += prodKey.substr( 14, 4 );

	return niceKey;
}

//---------------------------------------------------------------------------------------------
function toNiceRequestCode( requestCode )
{
	var re = / /g;
	return requestCode.replace( re, '-' );
}

//---------------------------------------------------------------------------------------------
function renderEditUnlockCode()
	// Appends the HTML elements needed to gather the unlock code from the user	
{
	var s="";
	var sz = gUnlockCodeFieldLen-1;
			
	for( var i=1; i<=gUnlockCodeFieldCnt; ++i )
	{
		if( i>1 ) s+='<span style="vertical-align:super;font:bold 13px Arial"> - </span>';
		s += '<input size="' + sz + '" maxlength="' + gUnlockCodeFieldLen + '" id="'+ gUnlockCodePrefix+i + '"';
		if( i<gUnlockCodeFieldCnt ) s += ' onkeypress="_onTabUnlockCode('+i+')"';
		s += '>'
 	}

	document.writeln( s );
}

function _onTabUnlockCode(i)
{
	var e = document.getElementById( gUnlockCodePrefix+i );
	if( e && e.value.length==e.maxLength )
	{
		i++;
		setFocus( gUnlockCodePrefix+i );
	}
}

//---------------------------------------------------------------------------------------------
function getUnlockCode()
	// Gather the user entered product key
{
	var e, code = "";
	
	for( var i=1; i<=gUnlockCodeFieldCnt; ++i)
	{
		e = document.getElementById( gUnlockCodePrefix+i );
		if(e) code += e.value;
	}
	
	return code;
}

//---------------------------------------------------------------------------------------------
function validateUnlockCode()
{
	var bValid = true;

	for( var i=1; i<=gUnlockCodeFieldCnt; ++i)
	{
		if( !isInputPopulated( gUnlockCodePrefix+i, gUnlockCodeFieldLen, gUnlockCodeFieldLen ) )
		{
			bValid = false;
			break;
		}
	}
	
	if( bValid ) parent.setDataSrcItem( "phoneUnlockCode", getUnlockCode() );
	
	return bValid;
}
